uniform vec3		sundir;
varying float		h;
varying vec3		cnormal;
varying float		depth;	
uniform float 		inScatter;
uniform float 		sunpower;

// costanti passate allo shader
uniform vec3  SUN; 	// = colore del sole
uniform vec3  cBr; 	// = RayLeigh
uniform vec3  cBm; 	// = Mie	
uniform	vec3  C0; 	// = cBr+cBm;	
uniform vec3  C1; 	// = 1.0/(cBr+cBm);

uniform float C4;	// = (1-g)^2
uniform float C5;	// = 1+g^2
uniform float C6;	// = 2*g
uniform float C7;	// = 3/2

////////////////////////////
void main()
{
	cnormal=normalize(cnormal);
	float cos=dot(-sundir,cnormal);
	float cos2=clamp(pow(clamp(-cos,0.0,1.0),3000.0),0.0,0.25)*4.0;
	
	float F1=(1.0 + cos*cos);
	float F2=(C4/pow(C5-C6*cos,C7));

	vec3 Br = cBr*F1;
	vec3 Bm = cBm*F2;

	vec3 Lin = (Br+Bm)*C1*SUN*(1.0-exp(-C0*5000000.0)); 
		
//	vec3 color=Lin*inScatter*0.01*sunpower*0.5;
//	float lum=dot(color,vec3(0.3,0.59,0.11));
		
	//float asb=clamp(cos,0.0,1.0);
	float delta=pow(clamp(h,0.0,1.0),20.0);
	//float delta2=delta*delta;
	gl_FragColor.xyz=(Lin*inScatter*0.01*sunpower*0.5*lerp(vec3(0.1,0.2,0.3),vec3(0.7,0.6,0.6),delta)) + (cos2*SUN) /*+ vec3(0.1,0.1,0.1)*/ ;
	//gl_FragColor.xyz=gl_FragColor.xyz*(1.0-delta2)+vec3(0.1,0.12,0.13)*delta2;
	gl_FragColor.w=1.0;
}
